/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWGuid;
import filenet.vw.api.VWLog;
import filenet.vw.api.VWLogDefinition;
import filenet.vw.api.VWQueue;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWRoster;
import filenet.vw.api.VWRosterDefinition;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWStepProcessorInfoDefinition;
import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.api.VWValidationError;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.api.VWWorkflowSignature;
import filenet.vw.base.CEObjectInfo;
import filenet.vw.base.CEObjectInfoCache;
import java.util.Hashtable;
import java.util.Vector;

class VWValidationContext {
    private VWSession m_vwSession = null;
    private VWSystemConfiguration m_sysConfig = null;
    private Vector m_validationErrors = new Vector();
    private CEObjectInfoCache m_ceObjectInfoCache = null;
    private VWStepProcessorInfoDefinition[] m_stepProcessorInfoDefinitions = null;
    private Hashtable<String, VWWorkflowSignature> m_workflowSignatureList = new Hashtable();
    private Hashtable<String, VWWorkflowDefinition> m_workflowDefinitionList = new Hashtable();

    protected VWValidationContext(VWSession vwSession, VWSystemConfiguration sysConfig, String sdfFileContents) throws VWException {
        this.m_vwSession = vwSession;
        if (sysConfig != null) {
            this.m_sysConfig = sysConfig;
        } else if (vwSession != null) {
            this.m_sysConfig = vwSession.fetchSystemConfiguration();
        }
        this.m_ceObjectInfoCache = new CEObjectInfoCache(this.m_vwSession, this.m_sysConfig, sdfFileContents);
    }

    protected VWValidationContext(VWSession vwSession, Vector validationErrors) throws VWException {
        this.m_vwSession = vwSession;
        if (vwSession != null) {
            this.m_sysConfig = vwSession.fetchSystemConfiguration();
        }
        if (validationErrors != null) {
            this.m_validationErrors = validationErrors;
        }
    }

    protected VWSession getVWSession() {
        return this.m_vwSession;
    }

    protected boolean getShouldFixupSteps() throws VWException {
        return true;
    }

    protected void resetValidationErrorList() {
        this.m_validationErrors = new Vector();
    }

    protected void addValidationError(VWValidationError theError) {
        this.m_validationErrors.addElement(theError);
    }

    protected VWValidationError[] getValidationErrors() {
        Object[] theErrors = null;
        if (this.m_validationErrors.size() > 0) {
            theErrors = new VWValidationError[this.m_validationErrors.size()];
            this.m_validationErrors.copyInto(theErrors);
        }
        return theErrors;
    }

    protected VWStepProcessorInfoDefinition[] getStepProcessorDefinitions() throws VWException {
        if (this.m_stepProcessorInfoDefinitions == null && this.m_sysConfig != null) {
            this.m_stepProcessorInfoDefinitions = this.m_sysConfig.getStepProcessorInfoDefinitions();
        }
        return this.m_stepProcessorInfoDefinitions;
    }

    protected VWQueueDefinition getQueueDefinition(String queueName) throws VWException {
        VWQueueDefinition queueDef = null;
        if (this.m_sysConfig != null && (queueDef = this.m_sysConfig.getQueueDefinition(queueName)) == null) {
            VWQueue vwQueue;
            if (this.m_vwSession != null && (vwQueue = this.m_vwSession.getQueue(queueName)) != null) {
                queueDef = vwQueue.fetchQueueDefinition();
            }
            if (queueDef == null) {
                throw new VWException("vw.api.VWValidationContextQueueDefinitionNotFound", "Definition not found for Queue: \"{0}\".", queueName);
            }
        }
        return queueDef;
    }

    protected VWRosterDefinition getRosterDefinition(String rosterName) throws VWException {
        VWRosterDefinition rosterDef = null;
        if (this.m_sysConfig != null && (rosterDef = this.m_sysConfig.getRosterDefinition(rosterName)) == null) {
            VWRoster vwRoster;
            if (this.m_vwSession != null && (vwRoster = this.m_vwSession.getRoster(rosterName)) != null) {
                rosterDef = vwRoster.fetchRosterDefinition();
            }
            if (rosterDef == null) {
                throw new VWException("vw.api.VWValidationContextRosterDefinitionNotFound", "Definition not found for Roster: \"{0}\".", rosterName);
            }
        }
        return rosterDef;
    }

    protected VWLogDefinition getLogDefinition(String eventLogName) throws VWException {
        VWLogDefinition eventLogDef = null;
        if (this.m_sysConfig != null && (eventLogDef = this.m_sysConfig.getLogDefinition(eventLogName)) == null && this.m_vwSession != null) {
            VWLog vwLog = this.m_vwSession.fetchEventLog(eventLogName);
            if (vwLog != null) {
                eventLogDef = vwLog.fetchLogDefinition();
            }
            if (eventLogDef == null) {
                throw new VWException("vw.api.VWValidationContextLogDefinitionNotFound", "The specified event log definition was not found. The event log definition specified was: \"{0}\". \nEnsure the event log exists and the correct identifier is specified.", eventLogName);
            }
        }
        return eventLogDef;
    }

    protected VWWorkflowSignature getWorkflowSignature(String workClassName) throws VWException {
        if (workClassName != null && workClassName.length() > 0 && this.m_workflowSignatureList.containsKey(workClassName)) {
            return this.m_workflowSignatureList.get(workClassName);
        }
        return null;
    }

    protected void putWorkflowSignature(String workClassName, VWWorkflowSignature workflowSignature) throws VWException {
        if (workClassName != null && workClassName.length() > 0 && workflowSignature != null) {
            this.updateFieldDefinitions(workflowSignature);
            this.m_workflowSignatureList.put(workClassName, workflowSignature);
        }
    }

    protected void updateFieldDefinitions(VWWorkflowSignature workflowSignature) {
        if (workflowSignature == null) {
            return;
        }
        VWFieldDefinition[] fieldDefs = workflowSignature.fieldDefinitions;
        if (fieldDefs != null) {
            for (int i = 0; i < fieldDefs.length; ++i) {
                if (fieldDefs[i].getFieldType() != 512) continue;
                try {
                    CEObjectInfo ceObjectInfo;
                    VWGuid requiredClass = fieldDefs[i].getRequiredClass();
                    if (requiredClass == null || (ceObjectInfo = this.getCEClassDefinition(requiredClass)) == null) continue;
                    fieldDefs[i].setCEObjectInfo(ceObjectInfo);
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
    }

    protected VWWorkflowDefinition getWorkflowDefinition(String workClassName) throws VWException {
        if (workClassName != null && workClassName.length() > 0 && this.m_workflowSignatureList.containsKey(workClassName)) {
            return this.m_workflowDefinitionList.get(workClassName);
        }
        return null;
    }

    protected void putWorkflowDefinition(String workClassName, VWWorkflowDefinition workflowDefinition) {
        if (workClassName != null && workClassName.length() > 0 && workflowDefinition != null) {
            this.m_workflowDefinitionList.put(workClassName, workflowDefinition);
        }
    }

    protected CEObjectInfo getCEClassDefinition(VWGuid classId) throws VWException {
        if (this.m_ceObjectInfoCache != null) {
            return this.m_ceObjectInfoCache.getCEClassDefinition(classId);
        }
        return null;
    }

    protected CEObjectInfo getCEObject(VWGuid classId, VWGuid objectId) throws VWException {
        if (this.m_ceObjectInfoCache != null) {
            return this.m_ceObjectInfoCache.getCEObject(classId, objectId);
        }
        return null;
    }
}

